/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionResolver;
import de.danielbechler.diff.node.DiffNode;
import java.util.HashMap;
import java.util.Map;

class PropertyNameInclusionResolver
implements InclusionResolver {
    private final Map<String, Inclusion> propertyNameInclusions = new HashMap<String, Inclusion>();
    private boolean containsIncluded;
    private boolean containsExcluded;

    PropertyNameInclusionResolver() {
    }

    public Inclusion getInclusion(DiffNode node) {
        if (node != null && !this.isInactive()) {
            Inclusion inclusion = this.propertyNameInclusions.get(node.getPropertyName());
            if (inclusion == Inclusion.INCLUDED || inclusion == Inclusion.EXCLUDED) {
                return inclusion;
            }
            Inclusion parentNodeInclusion = this.getInclusion(node.getParentNode());
            if (parentNodeInclusion == Inclusion.INCLUDED) {
                return Inclusion.INCLUDED;
            }
        }
        return Inclusion.DEFAULT;
    }

    public boolean enablesStrictIncludeMode() {
        return this.containsIncluded;
    }

    private boolean isInactive() {
        return !this.containsIncluded && !this.containsExcluded;
    }

    public void setInclusion(String propertyName, Inclusion inclusion) {
        this.propertyNameInclusions.put(propertyName, inclusion);
        this.containsIncluded = this.propertyNameInclusions.containsValue((Object)Inclusion.INCLUDED);
        this.containsExcluded = this.propertyNameInclusions.containsValue((Object)Inclusion.EXCLUDED);
    }
}

