/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.AutoEncryptionSettings;
import com.mongodb.ClientBulkWriteException;
import com.mongodb.ClientSessionOptions;
import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoQueryException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.RequestContext;
import com.mongodb.ServerApi;
import com.mongodb.TransactionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.ClientSession;
import com.mongodb.client.ListDatabasesIterable;
import com.mongodb.client.MongoCluster;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.SynchronousContextProvider;
import com.mongodb.client.internal.ChangeStreamIterableImpl;
import com.mongodb.client.internal.ClientSessionBinding;
import com.mongodb.client.internal.ClientSessionImpl;
import com.mongodb.client.internal.Crypt;
import com.mongodb.client.internal.CryptBinding;
import com.mongodb.client.internal.ListDatabasesIterableImpl;
import com.mongodb.client.internal.MongoDatabaseImpl;
import com.mongodb.client.internal.OperationExecutor;
import com.mongodb.client.model.bulk.ClientBulkWriteOptions;
import com.mongodb.client.model.bulk.ClientBulkWriteResult;
import com.mongodb.client.model.bulk.ClientNamespacedWriteModel;
import com.mongodb.internal.IgnorableRequestContext;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.TimeoutSettings;
import com.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import com.mongodb.internal.binding.ClusterBinding;
import com.mongodb.internal.binding.ReadBinding;
import com.mongodb.internal.binding.ReadWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.client.model.changestream.ChangeStreamLevel;
import com.mongodb.internal.connection.Cluster;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ReadConcernAwareNoOpSessionContext;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.ReadOperation;
import com.mongodb.internal.operation.SyncOperations;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.session.ServerSessionPool;
import com.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class MongoClusterImpl
implements MongoCluster {
    @Nullable
    private final AutoEncryptionSettings autoEncryptionSettings;
    private final Cluster cluster;
    private final CodecRegistry codecRegistry;
    @Nullable
    private final SynchronousContextProvider contextProvider;
    @Nullable
    private final Crypt crypt;
    private final Object originator;
    private final OperationExecutor operationExecutor;
    private final ReadConcern readConcern;
    private final ReadPreference readPreference;
    private final boolean retryReads;
    private final boolean retryWrites;
    @Nullable
    private final ServerApi serverApi;
    private final ServerSessionPool serverSessionPool;
    private final TimeoutSettings timeoutSettings;
    private final UuidRepresentation uuidRepresentation;
    private final WriteConcern writeConcern;
    private final SyncOperations<BsonDocument> operations;

    MongoClusterImpl(@Nullable AutoEncryptionSettings autoEncryptionSettings, Cluster cluster, CodecRegistry codecRegistry, @Nullable SynchronousContextProvider contextProvider, @Nullable Crypt crypt, Object originator, @Nullable OperationExecutor operationExecutor, ReadConcern readConcern, ReadPreference readPreference, boolean retryReads, boolean retryWrites, @Nullable ServerApi serverApi, ServerSessionPool serverSessionPool, TimeoutSettings timeoutSettings, UuidRepresentation uuidRepresentation, WriteConcern writeConcern) {
        this.autoEncryptionSettings = autoEncryptionSettings;
        this.cluster = cluster;
        this.codecRegistry = codecRegistry;
        this.contextProvider = contextProvider;
        this.crypt = crypt;
        this.originator = originator;
        this.operationExecutor = operationExecutor != null ? operationExecutor : new OperationExecutorImpl(timeoutSettings);
        this.readConcern = readConcern;
        this.readPreference = readPreference;
        this.retryReads = retryReads;
        this.retryWrites = retryWrites;
        this.serverApi = serverApi;
        this.serverSessionPool = serverSessionPool;
        this.timeoutSettings = timeoutSettings;
        this.uuidRepresentation = uuidRepresentation;
        this.writeConcern = writeConcern;
        this.operations = new SyncOperations<BsonDocument>(null, BsonDocument.class, readPreference, codecRegistry, readConcern, writeConcern, retryWrites, retryReads, timeoutSettings);
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public Long getTimeout(TimeUnit timeUnit) {
        Long timeoutMS = this.timeoutSettings.getTimeoutMS();
        return timeoutMS == null ? null : Long.valueOf(timeUnit.convert(timeoutMS, TimeUnit.MILLISECONDS));
    }

    @Override
    public MongoCluster withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, this.writeConcern);
    }

    @Override
    public MongoCluster withReadPreference(ReadPreference readPreference) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, this.writeConcern);
    }

    @Override
    public MongoCluster withWriteConcern(WriteConcern writeConcern) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, writeConcern);
    }

    @Override
    public MongoCluster withReadConcern(ReadConcern readConcern) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings, this.uuidRepresentation, this.writeConcern);
    }

    @Override
    public MongoCluster withTimeout(long timeout, TimeUnit timeUnit) {
        return new MongoClusterImpl(this.autoEncryptionSettings, this.cluster, this.codecRegistry, this.contextProvider, this.crypt, this.originator, this.operationExecutor, this.readConcern, this.readPreference, this.retryReads, this.retryWrites, this.serverApi, this.serverSessionPool, this.timeoutSettings.withTimeout(timeout, timeUnit), this.uuidRepresentation, this.writeConcern);
    }

    @Override
    public MongoDatabase getDatabase(String databaseName) {
        return new MongoDatabaseImpl(databaseName, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.retryReads, this.readConcern, this.uuidRepresentation, this.autoEncryptionSettings, this.timeoutSettings, this.operationExecutor);
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    @Nullable
    public Crypt getCrypt() {
        return this.crypt;
    }

    public OperationExecutor getOperationExecutor() {
        return this.operationExecutor;
    }

    public ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    public TimeoutSettings getTimeoutSettings() {
        return this.timeoutSettings;
    }

    @Override
    public ClientSession startSession() {
        return this.startSession(ClientSessionOptions.builder().defaultTransactionOptions(TransactionOptions.builder().readConcern(this.readConcern).writeConcern(this.writeConcern).build()).build());
    }

    @Override
    public ClientSession startSession(ClientSessionOptions options) {
        Assertions.notNull("options", options);
        ClientSessionOptions mergedOptions = ClientSessionOptions.builder(options).defaultTransactionOptions(TransactionOptions.merge(options.getDefaultTransactionOptions(), TransactionOptions.builder().readConcern(this.readConcern).writeConcern(this.writeConcern).readPreference(this.readPreference).build())).build();
        return new ClientSessionImpl(this.serverSessionPool, this.originator, mergedOptions, this.operationExecutor);
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return this.createListDatabaseNamesIterable(null);
    }

    @Override
    public MongoIterable<String> listDatabaseNames(ClientSession clientSession) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabaseNamesIterable(clientSession);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases(Document.class);
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases(ClientSession clientSession) {
        return this.listDatabases(clientSession, Document.class);
    }

    @Override
    public <TResult> ListDatabasesIterable<TResult> listDatabases(Class<TResult> clazz) {
        return this.createListDatabasesIterable(null, clazz);
    }

    @Override
    public <TResult> ListDatabasesIterable<TResult> listDatabases(ClientSession clientSession, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createListDatabasesIterable(clientSession, clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> clazz) {
        return this.watch(Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> clazz) {
        return this.createChangeStreamIterable(null, pipeline, clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> clazz) {
        return this.watch(clientSession, Collections.emptyList(), clazz);
    }

    @Override
    public ChangeStreamIterable<Document> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, Document.class);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> clazz) {
        Assertions.notNull("clientSession", clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, clazz);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> clientWriteModels) throws ClientBulkWriteException {
        Assertions.notNull("clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument("`clientWriteModels` must not be empty", !clientWriteModels.isEmpty());
        return this.executeBulkWrite(null, clientWriteModels, null);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(List<? extends ClientNamespacedWriteModel> clientWriteModels, ClientBulkWriteOptions options) throws ClientBulkWriteException {
        Assertions.notNull("clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument("`clientWriteModels` must not be empty", !clientWriteModels.isEmpty());
        Assertions.notNull("options", options);
        return this.executeBulkWrite(null, clientWriteModels, options);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels) throws ClientBulkWriteException {
        Assertions.notNull("clientSession", clientSession);
        Assertions.notNull("clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument("`clientWriteModels` must not be empty", !clientWriteModels.isEmpty());
        return this.executeBulkWrite(clientSession, clientWriteModels, null);
    }

    @Override
    public ClientBulkWriteResult bulkWrite(ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels, ClientBulkWriteOptions options) throws ClientBulkWriteException {
        Assertions.notNull("clientSession", clientSession);
        Assertions.notNull("clientWriteModels", clientWriteModels);
        Assertions.isTrueArgument("`clientWriteModels` must not be empty", !clientWriteModels.isEmpty());
        Assertions.notNull("options", options);
        return this.executeBulkWrite(clientSession, clientWriteModels, options);
    }

    private <T> ListDatabasesIterable<T> createListDatabasesIterable(@Nullable ClientSession clientSession, Class<T> clazz) {
        return new ListDatabasesIterableImpl<T>(clientSession, clazz, this.codecRegistry, ReadPreference.primary(), this.operationExecutor, this.retryReads, this.timeoutSettings);
    }

    private MongoIterable<String> createListDatabaseNamesIterable(@Nullable ClientSession clientSession) {
        return this.createListDatabasesIterable(clientSession, BsonDocument.class).nameOnly(true).map(result -> result.getString("name").getValue());
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, "admin", this.codecRegistry, this.readPreference, this.readConcern, this.operationExecutor, pipeline, resultClass, ChangeStreamLevel.CLIENT, this.retryReads, this.timeoutSettings);
    }

    private ClientBulkWriteResult executeBulkWrite(@Nullable ClientSession clientSession, List<? extends ClientNamespacedWriteModel> clientWriteModels, @Nullable ClientBulkWriteOptions options) {
        Assertions.isTrue("`autoEncryptionSettings` is null, as bulkWrite does not currently support automatic encryption", this.autoEncryptionSettings == null);
        return this.operationExecutor.execute(this.operations.clientBulkWriteOperation(clientWriteModels, options), this.readConcern, clientSession);
    }

    final class OperationExecutorImpl
    implements OperationExecutor {
        private final TimeoutSettings executorTimeoutSettings;

        OperationExecutorImpl(TimeoutSettings executorTimeoutSettings) {
            this.executorTimeoutSettings = executorTimeoutSettings;
        }

        @Override
        public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern) {
            return this.execute(operation, readPreference, readConcern, null);
        }

        @Override
        public <T> T execute(WriteOperation<T> operation, ReadConcern readConcern) {
            return this.execute(operation, readConcern, null);
        }

        @Override
        public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session) {
            if (session != null) {
                session.notifyOperationInitiated(operation);
            }
            ClientSession actualClientSession = this.getClientSession(session);
            ReadBinding binding = this.getReadBinding(readPreference, readConcern, actualClientSession, session == null);
            try {
                if (actualClientSession.hasActiveTransaction() && !binding.getReadPreference().equals(ReadPreference.primary())) {
                    throw new MongoClientException("Read preference in a transaction must be primary");
                }
                T t2 = operation.execute(binding);
                return t2;
            }
            catch (MongoException e) {
                MongoException exceptionToHandle = OperationHelper.unwrap(e);
                this.labelException(actualClientSession, exceptionToHandle);
                this.clearTransactionContextOnTransientTransactionError(session, exceptionToHandle);
                throw e;
            }
            finally {
                binding.release();
            }
        }

        @Override
        public <T> T execute(WriteOperation<T> operation, ReadConcern readConcern, @Nullable ClientSession session) {
            if (session != null) {
                session.notifyOperationInitiated(operation);
            }
            ClientSession actualClientSession = this.getClientSession(session);
            WriteBinding binding = this.getWriteBinding(readConcern, actualClientSession, session == null);
            try {
                T t2 = operation.execute(binding);
                return t2;
            }
            catch (MongoException e) {
                MongoException exceptionToHandle = OperationHelper.unwrap(e);
                this.labelException(actualClientSession, exceptionToHandle);
                this.clearTransactionContextOnTransientTransactionError(session, exceptionToHandle);
                throw e;
            }
            finally {
                binding.release();
            }
        }

        @Override
        public OperationExecutor withTimeoutSettings(TimeoutSettings newTimeoutSettings) {
            if (Objects.equals(this.executorTimeoutSettings, newTimeoutSettings)) {
                return this;
            }
            return new OperationExecutorImpl(newTimeoutSettings);
        }

        @Override
        public TimeoutSettings getTimeoutSettings() {
            return this.executorTimeoutSettings;
        }

        WriteBinding getWriteBinding(ReadConcern readConcern, ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(ReadPreference.primary(), readConcern, session, ownsSession);
        }

        ReadBinding getReadBinding(ReadPreference readPreference, ReadConcern readConcern, ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(readPreference, readConcern, session, ownsSession);
        }

        ReadWriteBinding getReadWriteBinding(ReadPreference readPreference, ReadConcern readConcern, ClientSession session, boolean ownsSession) {
            ClusterAwareReadWriteBinding readWriteBinding = new ClusterBinding(MongoClusterImpl.this.cluster, this.getReadPreferenceForBinding(readPreference, session), readConcern, this.getOperationContext(session, readConcern));
            if (MongoClusterImpl.this.crypt != null) {
                readWriteBinding = new CryptBinding(readWriteBinding, MongoClusterImpl.this.crypt);
            }
            return new ClientSessionBinding(session, ownsSession, readWriteBinding);
        }

        private OperationContext getOperationContext(ClientSession session, ReadConcern readConcern) {
            return new OperationContext(this.getRequestContext(), new ReadConcernAwareNoOpSessionContext(readConcern), TimeoutContext.createTimeoutContext(session, this.executorTimeoutSettings), MongoClusterImpl.this.serverApi);
        }

        private RequestContext getRequestContext() {
            RequestContext context = null;
            if (MongoClusterImpl.this.contextProvider != null) {
                context = MongoClusterImpl.this.contextProvider.getContext();
            }
            return context == null ? IgnorableRequestContext.INSTANCE : context;
        }

        private void labelException(ClientSession session, MongoException e) {
            if (session.hasActiveTransaction() && (e instanceof MongoSocketException || e instanceof MongoTimeoutException || e instanceof MongoQueryException && e.getCode() == 91) && !e.hasErrorLabel("UnknownTransactionCommitResult")) {
                e.addLabel("TransientTransactionError");
            }
        }

        private void clearTransactionContextOnTransientTransactionError(@Nullable ClientSession session, MongoException e) {
            if (session != null && e.hasErrorLabel("TransientTransactionError")) {
                session.clearTransactionContext();
            }
        }

        private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable ClientSession session) {
            if (session == null) {
                return readPreference;
            }
            if (session.hasActiveTransaction()) {
                ReadPreference readPreferenceForBinding = session.getTransactionOptions().getReadPreference();
                if (readPreferenceForBinding == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
                }
                return readPreferenceForBinding;
            }
            return readPreference;
        }

        ClientSession getClientSession(@Nullable ClientSession clientSessionFromOperation) {
            ClientSession session;
            if (clientSessionFromOperation != null) {
                Assertions.isTrue("ClientSession from same MongoClient", clientSessionFromOperation.getOriginator() == MongoClusterImpl.this.originator);
                session = clientSessionFromOperation;
            } else {
                session = MongoClusterImpl.this.startSession(ClientSessionOptions.builder().causallyConsistent(false).defaultTransactionOptions(TransactionOptions.builder().readConcern(ReadConcern.DEFAULT).readPreference(ReadPreference.primary()).writeConcern(WriteConcern.ACKNOWLEDGED).build()).build());
            }
            return session;
        }
    }
}

