/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.async.function;

import com.mongodb.internal.async.MutableValue;
import com.mongodb.internal.async.SingleResultCallback;

@FunctionalInterface
public interface AsyncCallbackSupplier<R> {
    public void get(SingleResultCallback<R> var1);

    default public AsyncCallbackSupplier<R> whenComplete(Runnable after) {
        MutableValue<Boolean> afterExecuted = new MutableValue<Boolean>(false);
        Runnable trackableAfter = () -> {
            try {
                after.run();
            }
            finally {
                afterExecuted.set(true);
            }
        };
        return callback -> {
            SingleResultCallback<Object> callbackThatCallsAfter = (result, t2) -> {
                Throwable primaryException = t2;
                try {
                    trackableAfter.run();
                }
                catch (Throwable afterException) {
                    if (primaryException == null) {
                        primaryException = afterException;
                    } else {
                        primaryException.addSuppressed(afterException);
                    }
                    callback.onResult(null, primaryException);
                    return;
                }
                callback.onResult(result, primaryException);
            };
            Throwable primaryUnexpectedException = null;
            try {
                this.get(callbackThatCallsAfter);
            }
            catch (Throwable unexpectedException) {
                primaryUnexpectedException = unexpectedException;
                throw unexpectedException;
            }
            finally {
                if (primaryUnexpectedException != null && !((Boolean)afterExecuted.get()).booleanValue()) {
                    try {
                        trackableAfter.run();
                    }
                    catch (Throwable afterException) {
                        primaryUnexpectedException.addSuppressed(afterException);
                    }
                }
            }
        };
    }
}

