/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.async.function.AsyncCallbackLoop;
import com.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.mongodb.internal.async.function.LoopState;
import com.mongodb.internal.async.function.RetryState;
import com.mongodb.internal.async.function.RetryingAsyncCallbackSupplier;
import com.mongodb.internal.async.function.RetryingSyncSupplier;
import com.mongodb.internal.binding.AsyncWriteBinding;
import com.mongodb.internal.binding.WriteBinding;
import com.mongodb.internal.bulk.WriteRequest;
import com.mongodb.internal.connection.AsyncConnection;
import com.mongodb.internal.connection.Connection;
import com.mongodb.internal.connection.MongoWriteConcernWithResponseException;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.ProtocolHelper;
import com.mongodb.internal.operation.AsyncOperationHelper;
import com.mongodb.internal.operation.AsyncWriteOperation;
import com.mongodb.internal.operation.BulkWriteBatch;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.internal.operation.OperationHelper;
import com.mongodb.internal.operation.SyncOperationHelper;
import com.mongodb.internal.operation.WriteOperation;
import com.mongodb.internal.operation.retry.AttachmentKeys;
import com.mongodb.internal.session.SessionContext;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

public class MixedBulkWriteOperation
implements AsyncWriteOperation<BulkWriteResult>,
WriteOperation<BulkWriteResult> {
    private final MongoNamespace namespace;
    private final List<? extends WriteRequest> writeRequests;
    private final boolean ordered;
    private final boolean retryWrites;
    private final WriteConcern writeConcern;
    private Boolean bypassDocumentValidation;
    private BsonValue comment;
    private BsonDocument variables;

    public MixedBulkWriteOperation(MongoNamespace namespace, List<? extends WriteRequest> writeRequests, boolean ordered, WriteConcern writeConcern, boolean retryWrites) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeRequests = Assertions.notNull("writes", writeRequests);
        this.ordered = ordered;
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.retryWrites = retryWrites;
        Assertions.isTrueArgument("writes is not an empty list", !writeRequests.isEmpty());
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public List<? extends WriteRequest> getWriteRequests() {
        return this.writeRequests;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public MixedBulkWriteOperation bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public MixedBulkWriteOperation comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    public MixedBulkWriteOperation let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    public Boolean getRetryWrites() {
        return this.retryWrites;
    }

    private <R> Supplier<R> decorateWriteWithRetries(RetryState retryState, OperationContext operationContext, Supplier<R> writeFunction) {
        return new RetryingSyncSupplier<Object>(retryState, CommandOperationHelper.onRetryableWriteAttemptFailure(operationContext), this::shouldAttemptToRetryWrite, () -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            return writeFunction.get();
        });
    }

    private <R> AsyncCallbackSupplier<R> decorateWriteWithRetries(RetryState retryState, OperationContext operationContext, AsyncCallbackSupplier<R> writeFunction) {
        return new RetryingAsyncCallbackSupplier(retryState, CommandOperationHelper.onRetryableWriteAttemptFailure(operationContext), this::shouldAttemptToRetryWrite, callback -> {
            CommandOperationHelper.logRetryExecute(retryState, operationContext);
            writeFunction.get(callback);
        });
    }

    private boolean shouldAttemptToRetryWrite(RetryState retryState, Throwable attemptFailure) {
        BulkWriteTracker bulkWriteTracker = retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail);
        if (bulkWriteTracker.lastAttempt()) {
            return false;
        }
        boolean decision = CommandOperationHelper.loggingShouldAttemptToRetryWriteAndAddRetryableLabel(retryState, attemptFailure);
        if (decision) {
            bulkWriteTracker.advance();
        }
        return decision;
    }

    @Override
    public BulkWriteResult execute(WriteBinding binding) {
        TimeoutContext timeoutContext = binding.getOperationContext().getTimeoutContext();
        RetryState retryState = new RetryState(timeoutContext);
        BulkWriteTracker.attachNew(retryState, this.retryWrites, timeoutContext);
        Supplier<BulkWriteResult> retryingBulkWrite = this.decorateWriteWithRetries(retryState, binding.getOperationContext(), () -> SyncOperationHelper.withSourceAndConnection(binding::getWriteConnectionSource, true, (source, connection) -> {
            ConnectionDescription connectionDescription = connection.getDescription();
            retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true);
            SessionContext sessionContext = binding.getOperationContext().getSessionContext();
            WriteConcern writeConcern = CommandOperationHelper.validateAndGetEffectiveWriteConcern(this.writeConcern, sessionContext);
            if (!OperationHelper.isRetryableWrite(this.retryWrites, writeConcern, connectionDescription, sessionContext)) {
                this.handleMongoWriteConcernWithResponseException(retryState, true, timeoutContext);
            }
            OperationHelper.validateWriteRequests(connectionDescription, this.bypassDocumentValidation, this.writeRequests, writeConcern);
            if (!retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().isPresent()) {
                BulkWriteTracker.attachNew(retryState, BulkWriteBatch.createBulkWriteBatch(this.namespace, connectionDescription, this.ordered, writeConcern, this.bypassDocumentValidation, this.retryWrites, this.writeRequests, binding.getOperationContext(), this.comment, this.variables), timeoutContext);
            }
            return this.executeBulkWriteBatch(retryState, writeConcern, binding, (Connection)connection);
        }));
        try {
            return retryingBulkWrite.get();
        }
        catch (MongoException e) {
            throw CommandOperationHelper.transformWriteException(e);
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<BulkWriteResult> callback) {
        TimeoutContext timeoutContext = binding.getOperationContext().getTimeoutContext();
        RetryState retryState = new RetryState(timeoutContext);
        BulkWriteTracker.attachNew(retryState, this.retryWrites, timeoutContext);
        binding.retain();
        AsyncCallbackSupplier<BulkWriteResult> retryingBulkWrite = this.decorateWriteWithRetries(retryState, binding.getOperationContext(), (SingleResultCallback<R> funcCallback) -> AsyncOperationHelper.withAsyncSourceAndConnection(binding::getWriteConnectionSource, true, funcCallback, (source, connection, releasingCallback) -> {
            ConnectionDescription connectionDescription = connection.getDescription();
            retryState.attach(AttachmentKeys.maxWireVersion(), connectionDescription.getMaxWireVersion(), true);
            SessionContext sessionContext = binding.getOperationContext().getSessionContext();
            WriteConcern writeConcern = CommandOperationHelper.validateAndGetEffectiveWriteConcern(this.writeConcern, sessionContext);
            if (!OperationHelper.isRetryableWrite(this.retryWrites, writeConcern, connectionDescription, sessionContext) && this.handleMongoWriteConcernWithResponseExceptionAsync(retryState, releasingCallback, timeoutContext)) {
                return;
            }
            if (OperationHelper.validateWriteRequestsAndCompleteIfInvalid(connectionDescription, this.bypassDocumentValidation, this.writeRequests, writeConcern, releasingCallback)) {
                return;
            }
            try {
                if (!retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().isPresent()) {
                    BulkWriteTracker.attachNew(retryState, BulkWriteBatch.createBulkWriteBatch(this.namespace, connectionDescription, this.ordered, writeConcern, this.bypassDocumentValidation, this.retryWrites, this.writeRequests, binding.getOperationContext(), this.comment, this.variables), timeoutContext);
                }
            }
            catch (Throwable t2) {
                releasingCallback.onResult(null, t2);
                return;
            }
            this.executeBulkWriteBatchAsync(retryState, writeConcern, binding, (AsyncConnection)connection, releasingCallback);
        })).whenComplete(binding::release);
        retryingBulkWrite.get(AsyncOperationHelper.exceptionTransformingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER)));
    }

    private BulkWriteResult executeBulkWriteBatch(RetryState retryState, WriteConcern effectiveWriteConcern, WriteBinding binding, Connection connection) {
        BulkWriteTracker currentBulkWriteTracker = retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail);
        BulkWriteBatch currentBatch = currentBulkWriteTracker.batch().orElseThrow(Assertions::fail);
        int maxWireVersion = connection.getDescription().getMaxWireVersion();
        OperationContext operationContext = binding.getOperationContext();
        TimeoutContext timeoutContext = operationContext.getTimeoutContext();
        while (currentBatch.shouldProcessBatch()) {
            try {
                MongoException writeConcernBasedError;
                BsonDocument result = this.executeCommand(effectiveWriteConcern, operationContext, connection, currentBatch);
                if (currentBatch.getRetryWrites() && !operationContext.getSessionContext().hasActiveTransaction() && (writeConcernBasedError = ProtocolHelper.createSpecialException(result, connection.getDescription().getServerAddress(), "errMsg", timeoutContext)) != null) {
                    if (currentBulkWriteTracker.lastAttempt()) {
                        CommandOperationHelper.addRetryableWriteErrorLabel(writeConcernBasedError, maxWireVersion);
                        this.addErrorLabelsToWriteConcern(result.getDocument("writeConcernError"), writeConcernBasedError.getErrorLabels());
                    } else if (CommandOperationHelper.loggingShouldAttemptToRetryWriteAndAddRetryableLabel(retryState, writeConcernBasedError)) {
                        throw new MongoWriteConcernWithResponseException(writeConcernBasedError, result);
                    }
                }
                currentBatch.addResult(result);
                currentBulkWriteTracker = BulkWriteTracker.attachNext(retryState, currentBatch, timeoutContext);
                currentBatch = currentBulkWriteTracker.batch().orElseThrow(Assertions::fail);
            }
            catch (MongoException exception) {
                if (!retryState.isFirstAttempt() && !(exception instanceof MongoWriteConcernWithResponseException)) {
                    CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
                }
                this.handleMongoWriteConcernWithResponseException(retryState, false, timeoutContext);
                throw exception;
            }
        }
        try {
            return currentBatch.getResult();
        }
        catch (MongoException e) {
            retryState.markAsLastAttempt();
            throw e;
        }
    }

    private void executeBulkWriteBatchAsync(RetryState retryState, WriteConcern effectiveWriteConcern, AsyncWriteBinding binding, AsyncConnection connection, SingleResultCallback<BulkWriteResult> callback) {
        LoopState loopState = new LoopState();
        AsyncCallbackLoop loop = new AsyncCallbackLoop(loopState, iterationCallback -> {
            BulkWriteTracker currentBulkWriteTracker = retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail);
            loopState.attach(AttachmentKeys.bulkWriteTracker(), currentBulkWriteTracker, true);
            BulkWriteBatch currentBatch = currentBulkWriteTracker.batch().orElseThrow(Assertions::fail);
            int maxWireVersion = connection.getDescription().getMaxWireVersion();
            if (loopState.breakAndCompleteIf(() -> !currentBatch.shouldProcessBatch(), iterationCallback)) {
                return;
            }
            OperationContext operationContext = binding.getOperationContext();
            TimeoutContext timeoutContext = operationContext.getTimeoutContext();
            this.executeCommandAsync(effectiveWriteConcern, operationContext, connection, currentBatch, (result, t2) -> {
                if (t2 == null) {
                    MongoException writeConcernBasedError;
                    if (currentBatch.getRetryWrites() && !operationContext.getSessionContext().hasActiveTransaction() && (writeConcernBasedError = ProtocolHelper.createSpecialException(result, connection.getDescription().getServerAddress(), "errMsg", binding.getOperationContext().getTimeoutContext())) != null) {
                        if (currentBulkWriteTracker.lastAttempt()) {
                            CommandOperationHelper.addRetryableWriteErrorLabel(writeConcernBasedError, maxWireVersion);
                            this.addErrorLabelsToWriteConcern(result.getDocument("writeConcernError"), writeConcernBasedError.getErrorLabels());
                        } else if (CommandOperationHelper.loggingShouldAttemptToRetryWriteAndAddRetryableLabel(retryState, writeConcernBasedError)) {
                            iterationCallback.onResult(null, new MongoWriteConcernWithResponseException(writeConcernBasedError, result));
                            return;
                        }
                    }
                    currentBatch.addResult((BsonDocument)result);
                    BulkWriteTracker.attachNext(retryState, currentBatch, timeoutContext);
                    iterationCallback.onResult(null, null);
                } else {
                    if (t2 instanceof MongoException) {
                        MongoException exception = (MongoException)t2;
                        if (!retryState.isFirstAttempt() && !(exception instanceof MongoWriteConcernWithResponseException)) {
                            CommandOperationHelper.addRetryableWriteErrorLabel(exception, maxWireVersion);
                        }
                        if (this.handleMongoWriteConcernWithResponseExceptionAsync(retryState, null, timeoutContext)) {
                            return;
                        }
                    }
                    iterationCallback.onResult(null, t2);
                }
            });
        });
        loop.run((voidResult, t2) -> {
            if (t2 != null) {
                callback.onResult(null, t2);
            } else {
                BulkWriteResult result;
                try {
                    result = ((BulkWriteBatch)loopState.attachment(AttachmentKeys.bulkWriteTracker()).flatMap(BulkWriteTracker::batch).orElseThrow(Assertions::fail)).getResult();
                }
                catch (Throwable loopResultT) {
                    if (loopResultT instanceof MongoException) {
                        retryState.markAsLastAttempt();
                    }
                    callback.onResult(null, loopResultT);
                    return;
                }
                callback.onResult(result, null);
            }
        });
    }

    private void handleMongoWriteConcernWithResponseException(RetryState retryState, boolean breakAndThrowIfDifferent, TimeoutContext timeoutContext) {
        if (!retryState.isFirstAttempt()) {
            RuntimeException prospectiveFailedResult = retryState.exception().orElse(null);
            boolean prospectiveResultIsWriteConcernException = prospectiveFailedResult instanceof MongoWriteConcernWithResponseException;
            retryState.breakAndThrowIfRetryAnd(() -> breakAndThrowIfDifferent && !prospectiveResultIsWriteConcernException);
            if (prospectiveResultIsWriteConcernException) {
                retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().ifPresent(bulkWriteBatch -> {
                    bulkWriteBatch.addResult((BsonDocument)((MongoWriteConcernWithResponseException)prospectiveFailedResult).getResponse());
                    BulkWriteTracker.attachNext(retryState, bulkWriteBatch, timeoutContext);
                });
            }
        }
    }

    private boolean handleMongoWriteConcernWithResponseExceptionAsync(RetryState retryState, @Nullable SingleResultCallback<BulkWriteResult> callback, TimeoutContext timeoutContext) {
        if (!retryState.isFirstAttempt()) {
            RuntimeException prospectiveFailedResult = retryState.exception().orElse(null);
            boolean prospectiveResultIsWriteConcernException = prospectiveFailedResult instanceof MongoWriteConcernWithResponseException;
            if (callback != null && retryState.breakAndCompleteIfRetryAnd(() -> !prospectiveResultIsWriteConcernException, callback)) {
                return true;
            }
            if (prospectiveResultIsWriteConcernException) {
                retryState.attachment(AttachmentKeys.bulkWriteTracker()).orElseThrow(Assertions::fail).batch().ifPresent(bulkWriteBatch -> {
                    bulkWriteBatch.addResult((BsonDocument)((MongoWriteConcernWithResponseException)prospectiveFailedResult).getResponse());
                    BulkWriteTracker.attachNext(retryState, bulkWriteBatch, timeoutContext);
                });
            }
        }
        return false;
    }

    @Nullable
    private BsonDocument executeCommand(WriteConcern effectiveWriteConcern, OperationContext operationContext, Connection connection, BulkWriteBatch batch) {
        return connection.command(this.namespace.getDatabaseName(), batch.getCommand(), NoOpFieldNameValidator.INSTANCE, null, batch.getDecoder(), operationContext, this.shouldExpectResponse(batch, effectiveWriteConcern), batch.getPayload());
    }

    private void executeCommandAsync(WriteConcern effectiveWriteConcern, OperationContext operationContext, AsyncConnection connection, BulkWriteBatch batch, SingleResultCallback<BsonDocument> callback) {
        connection.commandAsync(this.namespace.getDatabaseName(), batch.getCommand(), NoOpFieldNameValidator.INSTANCE, null, batch.getDecoder(), operationContext, this.shouldExpectResponse(batch, effectiveWriteConcern), batch.getPayload(), callback);
    }

    private boolean shouldExpectResponse(BulkWriteBatch batch, WriteConcern effectiveWriteConcern) {
        return effectiveWriteConcern.isAcknowledged() || this.ordered && batch.hasAnotherBatch();
    }

    private void addErrorLabelsToWriteConcern(BsonDocument result, Set<String> errorLabels) {
        if (!result.containsKey("errorLabels")) {
            result.put("errorLabels", new BsonArray(errorLabels.stream().map(BsonString::new).collect(Collectors.toList())));
        }
    }

    public static final class BulkWriteTracker {
        private int attempt = 0;
        private final int attempts;
        private final boolean retryUntilTimeoutThrowsException;
        @Nullable
        private final BulkWriteBatch batch;

        static void attachNew(RetryState retryState, boolean retry, TimeoutContext timeoutContext) {
            retryState.attach(AttachmentKeys.bulkWriteTracker(), new BulkWriteTracker(retry, null, timeoutContext), false);
        }

        static void attachNew(RetryState retryState, BulkWriteBatch batch, TimeoutContext timeoutContext) {
            BulkWriteTracker.attach(retryState, new BulkWriteTracker(batch.getRetryWrites(), batch, timeoutContext));
        }

        static BulkWriteTracker attachNext(RetryState retryState, BulkWriteBatch batch, TimeoutContext timeoutContext) {
            BulkWriteBatch nextBatch = batch.getNextBatch();
            BulkWriteTracker nextTracker = new BulkWriteTracker(nextBatch.getRetryWrites(), nextBatch, timeoutContext);
            BulkWriteTracker.attach(retryState, nextTracker);
            return nextTracker;
        }

        private static void attach(RetryState retryState, BulkWriteTracker tracker) {
            retryState.attach(AttachmentKeys.bulkWriteTracker(), tracker, false);
            BulkWriteBatch batch = tracker.batch;
            if (batch != null) {
                retryState.attach(AttachmentKeys.retryableCommandFlag(), batch.getRetryWrites(), false).attach(AttachmentKeys.commandDescriptionSupplier(), () -> batch.getPayload().getPayloadType().toString(), false);
            }
        }

        private BulkWriteTracker(boolean retry, @Nullable BulkWriteBatch batch, TimeoutContext timeoutContext) {
            this.attempts = retry ? 2 : 1;
            this.batch = batch;
            this.retryUntilTimeoutThrowsException = timeoutContext.hasTimeoutMS();
        }

        boolean lastAttempt() {
            if (this.retryUntilTimeoutThrowsException) {
                return false;
            }
            return this.attempt == this.attempts - 1;
        }

        void advance() {
            Assertions.assertTrue(!this.lastAttempt());
            ++this.attempt;
        }

        Optional<BulkWriteBatch> batch() {
            return Optional.ofNullable(this.batch);
        }
    }
}

