/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.util;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Strings {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\\s*\\n\\s*");

    private Strings() {
    }

    public static boolean hasText(String s2) {
        return s2 != null && s2.trim().length() != 0;
    }

    public static boolean isEmpty(String s2) {
        return !Strings.hasText(s2);
    }

    public static String join(String delimiter, Object ... elements) {
        StringBuilder sb = new StringBuilder();
        for (Object part : elements) {
            if (part == null) continue;
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(part.toString());
        }
        return sb.toString();
    }

    public static String join(String delimiter, Collection<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        return Strings.join(delimiter, elements.toArray(new Object[elements.size()]));
    }

    public static String toSingleLineString(Object object) {
        if (object != null) {
            String s2 = object.toString().trim();
            Matcher matcher = LINE_BREAK_PATTERN.matcher(s2);
            return matcher.replaceAll(" \\\\ ");
        }
        return null;
    }

    public static String indent(int times, String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append("  ");
        }
        sb.append(text);
        return sb.toString();
    }
}

